package gov.cms.grouper.snf.component.v100.logic;

import static gov.cms.grouper.snf.component.v100.TestUtil.of;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.spy;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.CognitiveLevel;
import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.util.ClaimInfo;

public class CognitiveLevelTest {
  public static final int version = 100;

  public static CognitiveLevelLogic make() {
    return make(Arrays.asList());

  }

  public static CognitiveLevelLogic make(List<Assessment> assessments) {
    ClaimInfo claim = of(assessments);
    doReturn(version).when(claim).getVersion();

    CognitiveLevelLogic logic = new CognitiveLevelLogic(claim);
    logic = spy(logic);

    return logic;
  }

  @Test
  public void testStep1() {
    CognitiveLevelLogic cll = make();
    Assessment test1 = new Assessment("C0500", "C0500", 15);
    Assessment test2 = new Assessment("C0500", "C0500", "^");
    Assessment test3 = new Assessment("C0500", "C0500", "-");

    Assertions.assertEquals(CognitiveLevel.COGNITIVELY_INTACT, cll.step1(() -> null, () -> test1));
    Assertions.assertNull(cll.step1(() -> null, () -> test2));
    Assertions.assertNull(cll.step1(() -> null, () -> test3));
  }

  @Test
  public void testStep2To2a() {
    CognitiveLevelLogic cll = make();

    Assertions.assertEquals(CognitiveLevel.SEVERELY_IMPARED,
        cll.step2To2a(() -> null, () -> 3, () -> false));

    Assertions.assertEquals(CognitiveLevel.SEVERELY_IMPARED,
        cll.step2To2a(() -> null, () -> 1, () -> true));
  }

  @Test
  public void testStep2bTo2e() {
    CognitiveLevelLogic cll = make();

    Assertions.assertEquals(CognitiveLevel.MODERATELY_IMPAIRED,
        cll.step2bTo2e(() -> 2, () -> 2, () -> 1));

    Assertions.assertEquals(CognitiveLevel.MILDLY_IMPAIRED,
        cll.step2bTo2e(() -> 1, () -> 1, () -> 1));

    Assertions.assertEquals(CognitiveLevel.COGNITIVELY_INTACT,
        cll.step2bTo2e(() -> 0, () -> 0, () -> 0));
  }

  @Test
  public void testExec() {


    List<Assessment> assessments =
        Arrays.asList(new Assessment(Rai300.C1000.name(), Rai300.C1000.name(), 1));

    CognitiveLevel expected = CognitiveLevel.MILDLY_IMPAIRED;
    CognitiveLevel actual = make(assessments).exec();
    Assertions.assertEquals(expected, actual);

  }

}
